@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> View  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">
	
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools pull-left" >
		   		<a href="{{ ($prevnext['prev'] != '' ? url('registrodepagosmant/'.$prevnext['prev'].'?return='.$return ) : '#') }}" class="tips btn btn-sm"><i class="fa fa-arrow-left"></i>  </a>	
				<a href="{{ ($prevnext['next'] != '' ? url('registrodepagosmant/'.$prevnext['next'].'?return='.$return ) : '#') }}" class="tips btn btn-sm "> <i class="fa fa-arrow-right"></i>  </a>					
			</div>	

			<div class="sbox-tools" >
				@if($access['is_add'] ==1)
		   		<a href="{{ url('registrodepagosmant/'.$id.'/edit?return='.$return) }}"   title="{{ __('core.btn_edit') }}"><i class="fa  fa-pencil"></i></a>
				@endif
				<a href="{{ url('registrodepagosmant?return='.$return) }}"   title="{{ __('core.btn_back') }}"><i class="fa  fa-times"></i></a>		
			</div>
		</div>
		<div class="sbox-content">
			<div class="table-responsive">
				<table class="table table-striped " >
					<tbody>	
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Residencia', (isset($fields['Residencia']['language'])? $fields['Residencia']['language'] : array())) }}</td>
						<td>{{ $row->Residencia}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Condominio', (isset($fields['Condominio']['language'])? $fields['Condominio']['language'] : array())) }}</td>
						<td>{{ $row->Condominio}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Cuota', (isset($fields['Cuota']['language'])? $fields['Cuota']['language'] : array())) }}</td>
						<td>{{ $row->Cuota}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Tipocuota', (isset($fields['Tipocuota']['language'])? $fields['Tipocuota']['language'] : array())) }}</td>
						<td>{{ $row->Tipocuota}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Pagorealizado', (isset($fields['Pagorealizado']['language'])? $fields['Pagorealizado']['language'] : array())) }}</td>
						<td>{{ $row->Pagorealizado}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Pagorestante', (isset($fields['Pagorestante']['language'])? $fields['Pagorestante']['language'] : array())) }}</td>
						<td>{{ $row->Pagorestante}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Mes', (isset($fields['Mes']['language'])? $fields['Mes']['language'] : array())) }}</td>
						<td>{{ $row->Mes}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Ano', (isset($fields['Ano']['language'])? $fields['Ano']['language'] : array())) }}</td>
						<td>{{ $row->Ano}} </td>
						
					</tr>
				
					<tr>
						<td width='30%' class='label-view text-right'>{{ SiteHelpers::activeLang('Pagostatus', (isset($fields['Pagostatus']['language'])? $fields['Pagostatus']['language'] : array())) }}</td>
						<td>{{ SiteHelpers::cuota($row->Pagostatus) }} </td>
						
					</tr>
				
					</tbody>	
				</table>   

			 	

			</div>
		</div>
	</div>
	</div>
</div>
@stop
