<?php namespace App\Http\Controllers;

use App\Models\Moduloseparador;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;
use Validator, Input, Redirect ; 


class ModuloseparadorController extends Controller {

	protected $layout = "layouts.main";
	protected $data = array();	
	public $module = 'moduloseparador';
	static $per_page	= '10';

	public function __construct()
	{
		
		parent::__construct();
		$this->model = new Moduloseparador();
		$this->info = $this->model->makeInfo( $this->module);
		$this->access = array();
	
		$this->data = array_merge(array(
			'pageTitle'	=> 	$this->info['title'],
			'pageNote'	=>  $this->info['note'],
			'pageModule'=> 'moduloseparador',
			'return'	=> self::returnUrl()
			
		),$this->data);

		
	}

	public function getIndex( Request $request )
	{

		$this->access = $this->model->validAccess($this->info['id'] , session('gid'));		
		if($this->access['is_view'] ==0) 
			return Redirect::to('dashboard')
				->with('messagetext', \Lang::get('core.note_restric'))->with('msgstatus','error');

		
		return view('moduloseparador.index',$this->data);
	}	



	function getUpdate(Request $request, $id = null)
	{
		
		$this->access = $this->model->validAccess($this->info['id'] , session('gid'));
		if($id =='')
		{
			if($this->access['is_add'] ==0 )
			return Redirect::to('dashboard')->with('messagetext',\Lang::get('core.note_restric'))->with('msgstatus','error');
		}	
		
		if($id !='')
		{
			if($this->access['is_edit'] ==0 )
			return Redirect::to('dashboard')->with('messagetext',\Lang::get('core.note_restric'))->with('msgstatus','error');
		}				
				
		$this->data['access']		= $this->access;
		return view('moduloseparador.form',$this->data);
	}	

	public function getShow( $id = null)
	{
		$this->access = $this->model->validAccess($this->info['id'] , session('gid'));
		if($this->access['is_detail'] ==0) 
			return Redirect::to('dashboard')
				->with('messagetext', \Lang::get('core.note_restric'))->with('msgstatus','error');
					
		
		$this->data['access']		= $this->access;
		return view('moduloseparador.view',$this->data);	
	}	

	function postSave( Request $request)
	{
		
	
	}	

	public function postDelete( Request $request)
	{
		$this->access = $this->model->validAccess($this->info['id'] , session('gid'));
		if($this->access['is_remove'] ==0) 
			return Redirect::to('dashboard')
				->with('messagetext', \Lang::get('core.note_restric'))->with('msgstatus','error');
		
	}			


}