<?php
// pagoadelantadomodal_V5.php (fragmento para SximoModal)
// UNION: mantenimientopago.ID <-> mantenimientopagodetalle.InvID

error_reporting(E_ALL);
ini_set('display_errors', '0');

if (file_exists(__DIR__ . '/dbconnection.php')) {
  include __DIR__ . '/dbconnection.php';
} elseif (file_exists(__DIR__ . '/../dbconnection.php')) {
  include __DIR__ . '/../dbconnection.php';
} else {
  @include 'dbconnection.php';
}

$Condominio = isset($_GET["Condominio"]) ? $_GET["Condominio"] : '';
$Residencia = isset($_GET["Residencia"]) ? $_GET["Residencia"] : '';
$BaseID     = isset($_GET["ID"]) ? $_GET["ID"] : '';

if (!isset($con)) {
  echo '<div style="padding:10px;background:#ffecec;border:1px solid #ffb3b3;color:#8a1f1f;border-radius:8px;font-size:12px;">
          <b>Error:</b> No se pudo cargar dbconnection.php (no existe $con)
        </div>';
  exit;
}

$resultMes = mysqli_query($con, "SELECT * FROM mes");
$resultAno = mysqli_query($con, "SELECT * FROM ano");
if (!$resultMes || !$resultAno) {
  echo '<div style="padding:10px;background:#ffecec;border:1px solid #ffb3b3;color:#8a1f1f;border-radius:8px;font-size:12px;">
          <b>Error DB:</b> '.htmlspecialchars(mysqli_error($con)).'
        </div>';
  exit;
}
?>

<div style="width:50%;margin:auto;">
  <form id="frmPagoAdelantado" class="form-horizontal" autocomplete="off">

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Aplicar desde Mes :</label><br>
    <select name="mes" style="width:100%;height:24px;margin-bottom:10px;" required>
      <option value="">------- Seleccionar -------</option>
      <?php while($m = mysqli_fetch_array($resultMes)): ?>
        <option value="<?php echo $m[1]; ?>"><?php echo $m[1]; ?></option>
      <?php endwhile; ?>
    </select>

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Año :</label><br>
    <select name="ano" style="width:100%;height:24px;margin-bottom:10px;" required>
      <option value="">------- Seleccionar -------</option>
      <?php while($a = mysqli_fetch_array($resultAno)): ?>
        <option value="<?php echo $a[1]; ?>"><?php echo $a[1]; ?></option>
      <?php endwhile; ?>
    </select>

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Aplicar primero en :</label><br>
    <select name="prioridad" style="width:100%;height:24px;margin-bottom:10px;" required>
      <option value="atrasados">Meses atrasados</option>
      <option value="futuros" selected>Meses futuros</option>
    </select>

    <label><i class="fa fa-arrow-circle-right fa-lg" style="color:#f29f41"></i> Monto :</label><br>
    <input type="number" step="0.01" name="total"
           style="margin-bottom:10px;width:100%;height:24px;"
           placeholder="0.00" required>

    <input type="hidden" name="condominio" value="<?php echo htmlspecialchars($Condominio, ENT_QUOTES, 'UTF-8'); ?>">
    <input type="hidden" name="residencia" value="<?php echo htmlspecialchars($Residencia, ENT_QUOTES, 'UTF-8'); ?>">
    <input type="hidden" name="base_id" value="<?php echo htmlspecialchars($BaseID, ENT_QUOTES, 'UTF-8'); ?>">

    <div id="msgBox" style="display:none; margin-top:10px; padding:10px; border-radius:8px; font-size:12px; line-height:1.35;"></div>

    <div align="center" style="margin-top:12px;">
      <button type="submit" id="btnEnviar" class="btn btn-default btn-sm" style="border-color:#f29f41;font-size:12px;">
        <i class="fa fa-file-import fa-lg"></i> Enviar
      </button>
    </div>

  </form>
</div>

<style>
select { text-align:center; text-align-last:center; }
option { text-align:left; }
</style>

<script>
(function(){
  function showErr(html){
    $('#msgBox').html(html).show().css({background:'#ffecec', border:'1px solid #ffb3b3', color:'#8a1f1f'});
  }
  function showOk(html){
    $('#msgBox').html(html).show().css({background:'#e8fff0', border:'1px solid #b6f0c7', color:'#126b2f'});
  }

  $(document).on('submit', '#frmPagoAdelantado', function(e){
    e.preventDefault();

    var form = this;
    $('#msgBox').hide();
    $('#btnEnviar').prop('disabled', true).text('Procesando...');

    var fd = new FormData(form);
    var dbg = {};
    fd.forEach(function(v,k){ dbg[k]=v; });

    $.ajax({
      url: 'pagos_adelantados_apply.php',
      type: 'POST',
      data: fd,
      processData: false,
      contentType: false,
      dataType: 'json',
      cache: false,
      timeout: 30000
    })
    .done(function(resp){
      if (resp && resp.ok) {
        showOk('✅ Pago aplicado correctamente');
        setTimeout(function(){
          try { if (window.parent && window.parent.$) window.parent.$('.modal:visible').modal('hide'); } catch(e){}
          try { if (window.parent) window.parent.location.reload(); else location.reload(); } catch(e){ location.reload(); }
        }, 1200);
      } else {
        showErr('<b>Error:</b> ' + (resp && resp.error ? resp.error : 'Respuesta inválida.')
          + '<br><br><b>POST enviado:</b><pre style="white-space:pre-wrap;max-height:220px;overflow:auto;">'
          + JSON.stringify(dbg, null, 2) + '</pre>');
      }
    })
    .fail(function(xhr){
      showErr('<b>AJAX falló</b><br><br><b>POST enviado:</b><pre style="white-space:pre-wrap;max-height:220px;overflow:auto;">'
        + JSON.stringify(dbg, null, 2) + '</pre>'
        + '<br><br><pre style="white-space:pre-wrap;max-height:220px;overflow:auto;">'
        + (xhr.responseText || '') + '</pre>');
    })
    .always(function(){
      $('#btnEnviar').prop('disabled', false).html('<i class="fa fa-file-import fa-lg"></i> Enviar');
    });
  });
})();
</script>
