@extends('layouts.app')

@section('content')
<div class="page-content row">
    <!-- Page header -->
    <div class="page-header">
      <div class="page-title">
        <h3> {{ $pageTitle }} <small>{{ $pageNote }}</small></h3>
      </div>

      <ul class="breadcrumb">
        <li><a href="{{ URL::to('') }}">Home</a></li>
        <li> Config</li>
        <li class="active">{{ $pageTitle }}</li>
      </ul>

	</div>
 <div class="page-content-wrapper m-t">  
@include('core/template/Tab',array('active'=>$page))

<div class="wrapper-container container" >

    <!-- Content grid -->
    <div class="block">
      <h5>Bootstrap Basic content grid</h5>
      <div class="table-responsive">
        <table class="table table-bordered table-striped">
          <thead>
            <tr>
              <th></th>
              <th>Extra small devices<small>Phones (&lt;768px)</small></th>
              <th>Small devices<small>Tablets (=768px)</small></th>
              <th>Medium devices<small>Desktops (=992px)</small></th>
              <th>Large devices<small>Desktops (=1200px)</small></th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <th>Grid behavior</th>
              <td>Horizontal at all times</td>
              <td colspan="3">Collapsed to start, horizontal above breakpoints</td>
            </tr>
            <tr>
              <th>Max container width</th>
              <td>None (auto)</td>
              <td>750px</td>
              <td>970px</td>
              <td>1170px</td>
            </tr>
            <tr>
              <th>Class prefix</th>
              <td><code>.col-xs-</code></td>
              <td><code>.col-sm-</code></td>
              <td><code>.col-md-</code></td>
              <td><code>.col-lg-</code></td>
            </tr>
            <tr>
              <th># of columns</th>
              <td colspan="4">12</td>
            </tr>
            <tr>
              <th>Max column width</th>
              <td class="text-muted">Auto</td>
              <td>60px</td>
              <td>78px</td>
              <td>95px</td>
            </tr>
            <tr>
              <th>Gutter width</th>
              <td colspan="4">30px (15px on each side of a column)</td>
            </tr>
            <tr>
              <th>Nestable</th>
              <td colspan="4">Yes</td>
            </tr>
            <tr>
              <th>Offsets</th>
              <td colspan="1" class="text-muted">N/A</td>
              <td colspan="3">Yes</td>
            </tr>
            <tr>
              <th>Column ordering</th>
              <td class="text-muted">N/A</td>
              <td colspan="3">Yes</td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
    <hr>
    <div class="block">
      <h6>Introduction</h6>
      <p>Grid systems are used for creating page layouts through a series of rows and columns that house your content. Here's how the Bootstrap grid system works:</p>
      <ul>
        <li>Rows must be placed within a <code>.container</code> (fixed-width) or <code>.container-fluid</code> (full-width) for proper alignment and padding</li>
        <li>Use rows to create horizontal groups of columns.</li>
        <li>Content should be placed within columns, and only columns may be immediate children of rows.</li>
        <li>Predefined grid classes like <code>.row</code> and <code>.col-xs-4</code> are available for quickly making grid layouts. LESS mixins can also be used for more semantic layouts.</li>
        <li>Columns create gutters (gaps between column content) via <code>padding</code>. That padding is offset in rows for the first and last column via negative margin on <code>.row</code>s.</li>
        <li>Grid columns are created by specifying the number of twelve available columns you wish to span. For example, three equal columns would use three <code>.col-xs-4</code>.</li>
      </ul>
      <div class="container-fluid">
        <div class="row demo-grid block-inner">
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-11">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-2">.col-md-1</div>
          <div class="col-md-10">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-3">.col-md-1</div>
          <div class="col-md-9">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-4">.col-md-1</div>
          <div class="col-md-8">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-5">.col-md-1</div>
          <div class="col-md-7">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-6">.col-md-1</div>
          <div class="col-md-6">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-7">.col-md-1</div>
          <div class="col-md-5">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-8">.col-md-1</div>
          <div class="col-md-4">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-9">.col-md-1</div>
          <div class="col-md-3">.col-md-11</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-10">.col-md-1</div>
          <div class="col-md-2">.col-md-11</div>
        </div>
        <div class="row demo-grid">
          <div class="col-md-11">.col-md-1</div>
          <div class="col-md-1">.col-md-11</div>
        </div>
      </div>
    </div>
    <hr>
    <div class="block">
      <h6>Stacked-to-horizontal</h6>
      <p>Using a single set of <code>.col-md-*</code> grid classes, you can create a basic grid system that starts out stacked on mobile devices and tablet devices (the extra small to small range) before becoming horizontal on desktop (medium) devices. Place grid columns in any <code>.row</code>.</p>
      <div class="container-fluid block">
        <div class="row demo-grid block-inner">
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
          <div class="col-md-1">.col-md-1</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-8">.col-md-8</div>
          <div class="col-md-4">.col-md-4</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-4">.col-md-4</div>
          <div class="col-md-4">.col-md-4</div>
          <div class="col-md-4">.col-md-4</div>
        </div>
        <div class="row demo-grid">
          <div class="col-md-6">.col-md-6</div>
          <div class="col-md-6">.col-md-6</div>
        </div>
      </div>
      <span class="subtitle">Example code:</span>
      <pre class="prettyprint linenums">&lt;div class="row"> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div> &lt;div class="col-md-1">.col-md-1&lt;/div>&lt;/div>&lt;div class="row"> &lt;div class="col-md-8">.col-md-8&lt;/div> &lt;div class="col-md-4">.col-md-4&lt;/div>&lt;/div>&lt;div class="row"> &lt;div class="col-md-4">.col-md-4&lt;/div> &lt;div class="col-md-4">.col-md-4&lt;/div> &lt;div class="col-md-4">.col-md-4&lt;/div>&lt;/div>&lt;div class="row"> &lt;div class="col-md-6">.col-md-6&lt;/div> &lt;div class="col-md-6">.col-md-6&lt;/div>&lt;/div></pre>
    </div>
    <hr>
    <div class="block">
      <h6>Mobile and desktop</h6>
      <p>Don't want your columns to simply stack in smaller devices? Use the extra small and medium device grid classes by adding <code>.col-xs-*</code> <code>.col-md-*</code> to your columns. See the example below for a better idea of how it all works.</p>
      <div class="container-fluid block">
        <!-- Stack the columns on mobile by making one full-width and the other half-width -->
        <div class="row demo-grid block-inner">
          <div class="col-xs-12 col-md-8">.col-xs-12 .col-md-8</div>
          <div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4</div>
        </div>
        <!-- Columns start at 50% wide on mobile and bump up to 33.3% wide on desktop -->
        <div class="row demo-grid block-inner">
          <div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4</div>
          <div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4</div>
          <div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4</div>
        </div>
        <!-- Columns are always 50% wide, on mobile and desktop -->
        <div class="row demo-grid">
          <div class="col-xs-6">.col-xs-6</div>
          <div class="col-xs-6">.col-xs-6</div>
        </div>
      </div>
      <span class="subtitle">Example code:</span>
      <pre class="prettyprint linenums">&lt;!-- Stack the columns on mobile by making one full-width and the other half-width -->&lt;div class="row"> &lt;div class="col-xs-12 col-md-8">.col-xs-12 .col-md-8&lt;/div> &lt;div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4&lt;/div>&lt;/div>&lt;!-- Columns start at 50% wide on mobile and bump up to 33.3% wide on desktop -->&lt;div class="row"> &lt;div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4&lt;/div> &lt;div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4&lt;/div> &lt;div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4&lt;/div>&lt;/div>&lt;!-- Columns are always 50% wide, on mobile and desktop -->&lt;div class="row"> &lt;div class="col-xs-6">.col-xs-6&lt;/div> &lt;div class="col-xs-6">.col-xs-6&lt;/div>&lt;/div></pre>
    </div>
    <hr>
    <div class="block">
      <h6>Mobile, tablet, desktops</h6>
      <p>Build on the previous example by creating even more dynamic and powerful layouts with tablet <code>.col-sm-*</code> classes.</p>
      <div class="container-fluid block">
        <div class="row demo-grid block-inner">
          <div class="col-xs-12 col-sm-6 col-md-8">.col-xs-12 .col-sm-6 .col-md-8</div>
          <div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4</div>
        </div>
        <div class="row demo-grid">
          <div class="col-xs-6 col-sm-4">.col-xs-6 .col-sm-4</div>
          <div class="col-xs-6 col-sm-4">.col-xs-6 .col-sm-4</div>
          <div class="clearfix visible-xs"></div>
          <div class="col-xs-6 col-sm-4">.col-xs-6 .col-sm-4</div>
        </div>
      </div>
      <span class="subtitle">Example code:</span>
      <pre class="prettyprint linenums">&lt;div class="row"> &lt;div class="col-xs-12 col-sm-6 col-md-8">.col-xs-12 .col-sm-6 .col-md-8&lt;/div> &lt;div class="col-xs-6 col-md-4">.col-xs-6 .col-md-4&lt;/div>&lt;/div>&lt;div class="row"> &lt;div class="col-xs-6 col-sm-4">.col-xs-6 .col-sm-4&lt;/div> &lt;div class="col-xs-6 col-sm-4">.col-xs-6 .col-sm-4&lt;/div> &lt;!-- Optional: clear the XS cols if their content doesn't match in height --> &lt;div class="clearfix visible-xs">&lt;/div> &lt;div class="col-xs-6 col-sm-4">.col-xs-6 .col-sm-4&lt;/div>&lt;/div></pre>
    </div>
    <hr>
    <div class="block">
      <h6>Offseting columns</h6>
      <p>Move columns to the right using <code>.col-md-offset-*</code> classes. These classes increase the left margin of a column by <code>*</code> columns. For example, <code>.col-md-offset-4</code> moves <code>.col-md-4</code> over four columns.</p>
      <div class="container-fluid block">
        <div class="row demo-grid block-inner">
          <div class="col-md-4">.col-md-4</div>
          <div class="col-md-4 col-md-offset-4">.col-md-4 .col-md-offset-4</div>
        </div>
        <div class="row demo-grid block-inner">
          <div class="col-md-3 col-md-offset-3">.col-md-3 .col-md-offset-3</div>
          <div class="col-md-3 col-md-offset-3">.col-md-3 .col-md-offset-3</div>
        </div>
        <div class="row demo-grid">
          <div class="col-md-6 col-md-offset-3">.col-md-6 .col-md-offset-3</div>
        </div>
      </div>
      <span class="subtitle">Example code:</span>
      <pre class="prettyprint linenums">&lt;div class="row"> &lt;div class="col-md-4">.col-md-4&lt;/div> &lt;div class="col-md-4 col-md-offset-4">.col-md-4 .col-md-offset-4&lt;/div>&lt;/div>&lt;div class="row"> &lt;div class="col-md-3 col-md-offset-3">.col-md-3 .col-md-offset-3&lt;/div> &lt;div class="col-md-3 col-md-offset-3">.col-md-3 .col-md-offset-3&lt;/div>&lt;/div>&lt;div class="row"> &lt;div class="col-md-6 col-md-offset-3">.col-md-6 .col-md-offset-3&lt;/div>&lt;/div></pre>
    </div>
    <hr>
    <div class="block">
      <h6>Nesting columns</h6>
      <p>To nest your content with the default grid, add a new <code>.row</code> and set of <code>.col-md-*</code> columns within an existing <code>.col-md-*</code> column. Nested rows should include a set of columns that add up to 12.</p>
      <div class="container-fluid block">
        <div class="row demo-grid">
          <div class="col-md-8">Level 1: .col-md-8
            <div class="row demo-grid container-fluid">
              <div class="col-md-6">Level 2: .col-md-6</div>
              <div class="col-md-6">Level 2: .col-md-6</div>
            </div>
          </div>
          <div class="col-md-4">Level 1: .col-md-4
            <div class="row demo-grid container-fluid">
              <div class="col-md-4">Level 2: .col-md-4</div>
              <div class="col-md-4">Level 2: .col-md-4</div>
              <div class="col-md-4">Level 2: .col-md-4</div>
            </div>
          </div>
        </div>
      </div>
      <span class="subtitle">Example code:</span>
      <pre class="prettyprint linenums">&lt;div class="row"> &lt;div class="col-md-9"> Level 1: .col-md-9 &lt;div class="row"> &lt;div class="col-md-6"> Level 2: .col-md-6 &lt;/div> &lt;div class="col-md-6"> Level 2: .col-md-6 &lt;/div> &lt;/div> &lt;/div>&lt;/div></pre>
    </div>
    <hr>
    <div class="block">
      <h6>Column ordering</h6>
      <p>Easily change the order of our built-in grid columns with <code>.col-md-push-*</code> and <code>.col-md-pull-*</code> modifier classes.</p>
      <div class="container-fluid block">
        <div class="row demo-grid">
          <div class="col-md-9 col-md-push-3">.col-md-9 .col-md-push-3</div>
          <div class="col-md-3 col-md-pull-9">.col-md-3 .col-md-pull-9</div>
        </div>
      </div>
      <span class="subtitle">Example code:</span>
      <pre class="prettyprint linenums">&lt;div class="row demo-grid"> &lt;div class="col-md-9 col-md-push-3">.col-md-9 .col-md-push-3&lt;/div> &lt;div class="col-md-3 col-md-pull-9">.col-md-3 .col-md-pull-9&lt;/div>&lt;/div></pre>
    </div>
  

</div>

</div>
</div>
@stop