<?php
include_once('database.php');

// Get daily report
$pdo = Database::connect();
$sql = 'SELECT * FROM events';
$db_events  = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

Database::disconnect();

//fetch tha data from the database 
$events = array();
foreach ($db_events as $db_event) {
	$event = new stdClass();
	$event->name = $db_event['name'];
	$event->image = $db_event['image'];
	
	$event->day = date('j', strtotime($db_event['start_date']));
	$event->month = date('n', strtotime($db_event['start_date']));
	$event->year = date('Y', strtotime($db_event['start_date']));
	if (!$db_event['end_date'] || ($db_event['end_date'] == '0000-00-00')) {
		$event->duration = 1; // If end_time is blank -> event's duration = 1 (day).	
	} else {
		if (date('Ymd', strtotime($db_event['start_date'])) == date('Ymd', strtotime($db_event['end_date']))) { // If start date and end date are same day -> event's duration = 1 (day).
			$event->duration = 1;
		} else {
			$start_day = date('Y-m-d', strtotime($db_event['start_date']));
			$end_day = date('Y-m-d', strtotime($db_event['end_date']));
			$event->duration = ceil(abs(strtotime($end_day) - strtotime($start_day)) / 86400) + 1; // Get event's duration = days between start date and end date.
		}
	}
	$event->time = $db_event['end_time'] ? $db_event['start_time'] . ' - ' . $db_event['end_time'] : $db_event['start_time'];
	
	$event->color = $db_event['color'];
	$event->location = $db_event['location'];
	$event->description = utf8_encode(nl2br($db_event['description']));
	
	array_push($events, $event);
}

echo json_encode($events);
?>