@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> Form  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">

	{!! Form::open(array('url'=>'reporteadmusuario?return='.$return, 'class'=>'form-horizontal validated','files' => true )) !!}
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools " >
				<a href="{{ url($pageModule.'?return='.$return) }}" class="tips btn btn-sm "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-times"></i></a> 
			</div>
			<div class="sbox-tools pull-left" >
				<button name="apply" class="tips btn btn-sm btn-apply  "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-check"></i> {{ __('core.sb_apply') }} </button>
				<button name="save" class="tips btn btn-sm btn-save"  title="{{ __('core.btn_back') }}" ><i class="fa  fa-paste"></i> {{ __('core.sb_save') }} </button> 
			</div>
		</div>	
		<div class="sbox-content clearfix">
	<ul class="parsley-error-list">
		@foreach($errors->all() as $error)
			<li>{{ $error }}</li>
		@endforeach
	</ul>		
<div class="col-md-12">
						<fieldset><legend> Reporteadmusuario</legend>
				{!! Form::hidden('ReportesID', $row['ReportesID']) !!}					
									  <div class="form-group  " >
										<label for="Nombre" class=" control-label col-md-4 text-left"> Nombre <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Nombre' id='Nombre' value='{{ $row['Nombre'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Descripcion" class=" control-label col-md-4 text-left"> Descripcion <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Descripcion' id='Descripcion' value='{{ $row['Descripcion'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Reporte" class=" control-label col-md-4 text-left"> Reporte <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Reporte' id='Reporte' value='{{ $row['Reporte'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Condominio" class=" control-label col-md-4 text-left"> Condominio <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Condominio' rows='5' id='Condominio' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Area" class=" control-label col-md-4 text-left"> Area <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <textarea name='area' rows='5' id='area' class='form-control input-sm '  
				           >{{ $row['area'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Mes" class=" control-label col-md-4 text-left"> Mes <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Mes' rows='5' id='Mes' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Ano" class=" control-label col-md-4 text-left"> Ano <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Ano' rows='5' id='Ano' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Tipo" class=" control-label col-md-4 text-left"> Tipo <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <textarea name='Tipo' rows='5' id='Tipo' class='form-control input-sm '  
				           >{{ $row['Tipo'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Actualizar" class=" control-label col-md-4 text-left"> Actualizar <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <textarea name='Actualizar' rows='5' id='Actualizar' class='form-control input-sm '  
				           >{{ $row['Actualizar'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> </fieldset>
			</div>
			
			

		</div>
	</div>
	<input type="hidden" name="action_task" value="save" />
	{!! Form::close() !!}
	</div>
</div>		
	
		 
   <script type="text/javascript">
	$(document).ready(function() { 
		
		
		
		$("#Condominio").jCombo("{!! url('reporteadmusuario/comboselect?filter=condominios:Nombre:Nombre') !!}",
		{  selected_value : '{{ $row["Condominio"] }}' });
		
		$("#Mes").jCombo("{!! url('reporteadmusuario/comboselect?filter=mes:Mes:Mes') !!}",
		{  selected_value : '{{ $row["Mes"] }}' });
		
		$("#Ano").jCombo("{!! url('reporteadmusuario/comboselect?filter=ano:Ano:Ano') !!}",
		{  selected_value : '{{ $row["Ano"] }}' });
		 		 

		$('.removeMultiFiles').on('click',function(){
			var removeUrl = '{{ url("reporteadmusuario/removefiles?file=")}}'+$(this).attr('url');
			$(this).parent().remove();
			$.get(removeUrl,function(response){});
			$(this).parent('div').empty();	
			return false;
		});		
		
	});
	</script>		 
@stop